/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support 
 * ----------------------------------------------------------------------------
 * Copyright (c) 2008, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

#ifndef ISO7816_3_H
#define ISO7816_3_H

//------------------------------------------------------------------------------
// Constants Definition
//------------------------------------------------------------------------------
#define TRUE  (1==1)
#define FALSE (0==1)

#define ATR_SIZE_MAX              55

// Default values for format and interface characters of Answer To Reset
#define ISO_TS_VAL              0x3B  // Direct convention
#define ISO_T0_VAL              0x7E  // TA1, TB1 and TC1 + 14 historical bytes
#define ISO_CAT_VAL             0x00  // Historical bytes category indicator
#define ISO_PRE_VAL             0x6A  // Pre-issuing data

// Maskbit for T0 ATR
#define T0_BIT_TA1_MASK         0x10
#define T0_BIT_TB1_MASK         0x20
#define T0_BIT_TC1_MASK         0x40
#define T0_BIT_TD1_MASK         0x80

#define T0_HISTORICAL_MASK      0x0F

#define CLASS_PTS               0xFF

#define TIME_ISO_GUARD          11    // 11 ISO bits time

#define ISO_INIT_RATIO          372
#define ISO_DI_PTS_MASK         0x0F

#define IS0_7813_ATR_HISTORICAL 14
#define IS0_7813_MAX_HISTORICAL (IS0_7813_ATR_HISTORICAL+4)

#define ISO_NULL_VAL            0x60 // NULL byte to restart byte procedure

//------------------------------------------------------------------------------
// Answer To Reset Definition
//------------------------------------------------------------------------------
typedef struct {

    unsigned char TS;                            // Initial
    unsigned char T0;                            // Format
    unsigned char TA1;                           // FI,DI
    unsigned char TB1;                           // II and PI1
    unsigned char TC1;                           // N
    unsigned char TD1;                           // N
    unsigned char CAT;                           // category indicator
    unsigned char PRE;                           // Pre-sending data
    unsigned long data_size;                     //
    unsigned char data[IS0_7813_ATR_HISTORICAL]; // Serial number

} S_iso_7816_atr;

//------------------------------------------------------------------------------
// PTS command format
//------------------------------------------------------------------------------
typedef struct {

    unsigned char Ptss;           // Instruction class (0xFF)
    unsigned char Pts0;           // PTS Format
    unsigned char Pts1;           // Parameter 1
    unsigned char Pts2;           // Parameter 2
    unsigned char Pts3;           // Parameter 3
    unsigned char Pck;            // Checksum

} S_iso_7813_to_pts;



#endif //#ifndef ISO7816_3_H


